local addonName = "GladeWoW_Stranniki"
local Settings = {}
GladeWoW_Stranniki_Settings = Settings

-- Функция загрузки сохранённых настроек
function Settings.LoadSettings(frame)
    if not GladeWoW_Settings then
        GladeWoW_Settings = { scale = 1.0 }
    end

    -- Устанавливаем сохранённый масштаб
    frame:SetScale(GladeWoW_Settings.scale)
end

-- Функция открытия меню настроек
function Settings.OpenSettingsMenu(frame)
    if Settings.settingsFrame then
        Settings.settingsFrame:Show()
        return
    end

    -- Создаем окно настроек
    local settingsFrame = CreateFrame("Frame", "GladeWoWSettingsFrame", UIParent)
    settingsFrame:SetSize(300, 150)
    settingsFrame:SetPoint("CENTER")
    settingsFrame:SetMovable(true)
    settingsFrame:EnableMouse(true)
    settingsFrame:RegisterForDrag("LeftButton")
    settingsFrame:SetScript("OnDragStart", settingsFrame.StartMoving)
    settingsFrame:SetScript("OnDragStop", settingsFrame.StopMovingOrSizing)

    -- Добавляем фон и границы
    settingsFrame:SetBackdrop({
        bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
        edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
        tile = true, tileSize = 32, edgeSize = 12,
        insets = { left = 4, right = 4, top = 4, bottom = 4 }
    })
    settingsFrame:SetBackdropColor(0, 0, 0, 0.8)
    settingsFrame:SetBackdropBorderColor(0, 0, 0, 1)

    -- Заголовок окна настроек
    local title = settingsFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge")
    title:SetPoint("TOP", settingsFrame, "TOP", 0, -10)
    title:SetText("Настройки GladeWoW")

    -- Ползунок для масштаба
    local scaleSlider = CreateFrame("Slider", "GladeWoWScaleSlider", settingsFrame, "OptionsSliderTemplate")
    scaleSlider:SetPoint("CENTER", settingsFrame, "CENTER", 0, 0)
    scaleSlider:SetMinMaxValues(0.5, 2.0)
    scaleSlider:SetValueStep(0.05)
    scaleSlider:SetValue(GladeWoW_Settings.scale)
    scaleSlider:SetWidth(200)
    scaleSlider:SetScript("OnValueChanged", function(self, value)
        -- Устанавливаем новый масштаб
        frame:SetScale(value)
        GladeWoW_Settings.scale = value  -- Явно сохраняем настройку
    end)

    -- Подпись к ползунку
    local scaleText = settingsFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
    scaleText:SetPoint("TOP", scaleSlider, "BOTTOM", 0, -5)
    scaleText:SetText("Масштаб панели")

    -- Кнопка закрытия настроек
    local closeButton = CreateFrame("Button", nil, settingsFrame, "UIPanelCloseButton")
    closeButton:SetPoint("TOPRIGHT", settingsFrame, "TOPRIGHT", -5, -5)
    closeButton:SetScript("OnClick", function() settingsFrame:Hide() end)

    -- Сохраняем ссылку на окно, чтобы не создавать его повторно
    Settings.settingsFrame = settingsFrame
end

-- Событие загрузки аддона, чтобы настройки применялись при входе в игру
local eventFrame = CreateFrame("Frame")
eventFrame:RegisterEvent("ADDON_LOADED")
eventFrame:SetScript("OnEvent", function(self, event, arg1)
    if arg1 == addonName then
        -- Загружаем настройки
        Settings.LoadSettings(GladeWoWFrame)
    end
end)
