-- Название аддона
local addonName = "GladeWoW_Stranniki"

-- Создаем главное окно
local frame = CreateFrame("Frame", "GladeWoWFrame", UIParent)
frame:SetSize(470, 60)
frame:SetPoint("CENTER", UIParent, "CENTER")
frame:SetMovable(true)
frame:EnableMouse(true)
frame:RegisterForDrag("LeftButton")
frame:SetScript("OnDragStart", frame.StartMoving)
frame:SetScript("OnDragStop", frame.StopMovingOrSizing)

-- Устанавливаем фон и границы окна
frame:SetBackdrop({
    bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
    edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
    tile = true, tileSize = 32, edgeSize = 8, 
    insets = { left = 2, right = 2, top = 2, bottom = 2 }
})
frame:SetBackdropColor(0, 0, 0, 0.8)
frame:SetBackdropBorderColor(0, 0, 0, 1)

-- Заголовок окна
local title = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
title:SetPoint("CENTER", frame, "TOP", 0, -10)
title:SetText("|cFF98FB98GladeWoW Странники|r")

-- Подключаем модули
local Buttons = GladeWoW_Stranniki_Buttons
local Commands = GladeWoW_Stranniki_Commands
local Settings = GladeWoW_Stranniki_Settings

-- Инициализация кнопок
Buttons.CreateButtons(frame)

-- Кнопка закрытия (правый верхний угол)
local closeButton = CreateFrame("Button", nil, frame, "UIPanelCloseButton")
closeButton:SetSize(26, 26)
closeButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 6, 6)
closeButton:SetScript("OnClick", function() frame:Hide() end)

-- **Кнопка настроек в виде иконки (верхний павый угол)**
local settingsButton = CreateFrame("Button", nil, frame)
settingsButton:SetSize(14, 14)
settingsButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", -15, 0)


-- Устанавливаем иконку шестерёнки
local settingsIcon = settingsButton:CreateTexture(nil, "BACKGROUND")
settingsIcon:SetTexture("Interface\\Icons\\trade_engineering") -- Указываем путь к иконке
settingsIcon:SetAllPoints()

-- Обработчик нажатия
settingsButton:SetScript("OnClick", function() 
    Settings.OpenSettingsMenu(frame)
end)

-- Добавляем подсказку
settingsButton:SetScript("OnEnter", function()
    GameTooltip:SetOwner(settingsButton, "ANCHOR_RIGHT")
    GameTooltip:SetText("Настройки", 1, 1, 1)
    GameTooltip:Show()
end)
settingsButton:SetScript("OnLeave", function()
    GameTooltip:Hide()
end)

-- Создаём переменную для кнопки
local leaveButton = _G["LeaveButton"]

-- Загружаем настройки
Settings.LoadSettings(frame)

-- Сообщение о загрузке
print("|cFF98FB98GladeWoW Странники|r |cFFE6E6FAготов к использованию!|r")
