local addonName = "GladeWoW_Stranniki"
local Buttons = {}
GladeWoW_Stranniki_Buttons = Buttons

-- Список кнопок
Buttons.buttons = {
    { 
        text = "Атаковать!", 
        command = "attack", 
        icon = "Interface\\Icons\\Ability_Warrior_Charge",
        description = "Приказать Странникам атаковать выбранную цель.\nОткажутся атаковать будучи в пассивном режиме!",
    },
    { 
        text = "Держать позицию!", 
        command = "stay", 
        icon = "Interface\\Icons\\Ability_Defend",
        description = "Приказать Странникам занять и оборонять вашу\nтекущую позицию и входят в боевой режим."
    },
    { 
        text = "За мной", 
        command = "follow", 
        icon = "Interface\\Icons\\Ability_Tracking",
        description = "Приказать Странникам следовать за вами перейдя\nв боевой режим."
    },
    { 
        text = "Отступаем!", 
        command = "flee", 
        icon = "Interface\\Icons\\inv_bannerpvp_03",
        description = "Приказать Странникам следовать за вами перейдя\nв пассивный режим."
    },
    { 
        text = "Дистанционный бой", 
        command = "runaway", 
        icon = "Interface\\Icons\\inv_weapon_crossbow_01",
        description = "Приказать Странникам занять позиции и атаковать\nврага соблюдая безопасное расстояние."
    },
    { 
        text = "Зачистить", 
        command = "grind", 
        icon = "Interface\\Icons\\Ability_CriticalStrike",
        description = "Странники зачищают местность от существ не выходя\nиз пассивного режима. Принуждает собрать добычу поблизости."
    },
	{ 
        text = "Покиньте тела", 
        command = "release", 
        icon = "Interface\\Icons\\spell_shadow_twistedfaith",
        description = "Приказать Странникам покинуть свои тела, когда они\nуже мертвы."
    },
	{ 
        text = "Возродитесь", 
        command = "revive", 
        icon = "Interface\\Icons\\spell_holy_holyguidance",
        description = "Приказать Странникам возродиться, находясь рядом с\nЦелителем душ."
    },
    { 
        text = "Рассредоточиться", 
        command = "disperse set", 
        icon = "Interface\\Icons\\ability_spy",
        description = "Приказать Странникам держаться на определённой дистанци\nдруг от друга."
    },
    { 
        text = "Призвать Странников!", 
        command = "summon", 
        icon = "Interface\\Icons\\spell_holy_crusade",
        description = "Приказать Странникам экстренно переместиться к вам."
    }

}

-- Таблица для хранения времени последнего нажатия кнопок
Buttons.lastClickTime = {}

-- Функция создания кнопок
function Buttons.CreateButtons(frame)
    local buttonX = 10
    for i, buttonInfo in ipairs(Buttons.buttons) do
        local button = CreateFrame("Button", nil, frame, "ActionButtonTemplate")
        button:SetSize(40, 40)
        button:SetPoint("LEFT", frame, "LEFT", buttonX, -6)
        buttonX = buttonX + 45

        -- Текстура иконки
        local icon = button:CreateTexture(nil, "BACKGROUND")
        icon:SetTexture(buttonInfo.icon)
        icon:SetAllPoints()

        -- Анимация перезарядки
        local cooldown = CreateFrame("Cooldown", nil, button, "CooldownFrameTemplate")
        cooldown:SetAllPoints()

        -- Обработчики событий
        button:SetScript("OnEnter", function()
            GameTooltip:SetOwner(button, "ANCHOR_BOTTOMRIGHT")
            GameTooltip:SetText(buttonInfo.text, 0.5, 1.0, 0.5)
            GameTooltip:AddLine(buttonInfo.description, 0.8, 0.6, 1.0)
            GameTooltip:Show()
        end)
        button:SetScript("OnLeave", function()
            GameTooltip:Hide()
        end)
        button:SetScript("OnClick", function()
            PlaySound(856) -- Стандартный звук нажатия кнопки
            local currentTime = GetTime()
            if Buttons.lastClickTime[button] and (currentTime - Buttons.lastClickTime[button]) < 1 then
                UIErrorsFrame:AddMessage("Кнопка на перезарядке!", 1.0, 0.1, 0.1, 1.0)
                return
            end

            Buttons.lastClickTime[button] = currentTime
            cooldown:SetCooldown(currentTime, 1) -- Задержка 1 секунда

            -- Обработка кнопки "Рассредоточиться"
            if buttonInfo.text == "Рассредоточиться" then
                StaticPopupDialogs["DISPERSEDISTANCE"] = {
                    text = "Введите дистанцию (1-99 метров):",
                    button1 = "OK",
                    button2 = "Отмена",
                    hasEditBox = true,
                    OnShow = function(self)
                        self.editBox:SetNumeric(true)
                    end,
                    OnAccept = function(self)
                        local distance = tonumber(self.editBox:GetText())
                        if distance and distance >= 1 and distance <= 99 then
                            GladeWoW_Stranniki_Commands.SendCommand(buttonInfo.command .. " " .. math.floor(distance))
                        else
                            UIErrorsFrame:AddMessage("Некорректная дистанция!", 1.0, 0.1, 0.1, 1.0)
                        end
                    end,
                    timeout = 0,
                    whileDead = true,
                    hideOnEscape = true,
                }
                StaticPopup_Show("DISPERSEDISTANCE")
            else
                GladeWoW_Stranniki_Commands.SendCommand(buttonInfo.command)
            end
        end)
    end
end